---
title: GraphQL API - Limits · Cloudflare Analytics docs
description: >-
  Cloudflare GraphQL API exposes more than 70 datasets representing products
  with

  different configurations and data availability for different zones and
  accounts

  plans.
lastUpdated: 2025-06-23T09:00:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/graphql-api/limits/
  md: https://developers.cloudflare.com/analytics/graphql-api/limits/index.md
---

Cloudflare GraphQL API exposes more than 70 datasets representing products with different configurations and data availability for different zones and accounts plans.

To support this variety of products, Cloudflare GraphQL API has three layers of limits:

* global limits
* user limits
* node (dataset) limits

## Global limits

These limits are applied to every query for every plan:

* A zone-scoped query can include up to **10 zones**
* An account-scoped query can include only **1 account**

Additionally, there is a limited number of queries you can make per request. The total number of queries in a request is equal to the number of zone/account scopes, multiplied by the number of nodes to which they are applied.

## User limits

Cloudflare GraphQL API limits the number of GraphQL requests each user can send. The default quota is **300 GraphQL queries over 5-minute window**. It allows a user to run at least **1 query every second** or do a burst of 300 queries and then wait 5 minutes before issuing another query.

That rate limit is applied in addition to the [general rate limits enforced by the Cloudflare API](https://developers.cloudflare.com/fundamentals/api/reference/limits/).

## Node limits and availability

Each data node has its limits, such as:

* how far back in time can data be requested,
* the maximum time period (in seconds) that can be requested in one query,
* the maximum number of fields that can be requested in one query,
* the maximum number of records that can be returned in one query.

Node limits are tied to requested `zoneTag` or `accountTag`. Higher plans have access to a greater selection of datasets or fields, and can query over broader historical intervals.

To get exact boundaries and availability for your zone(s) or account, please refer to [settings](https://developers.cloudflare.com/analytics/graphql-api/features/discovery/settings/).
