---
title: AI Gateway adds DeepSeek as a Provider · Changelog
description: AI Gateway has added DeepSeek as a new provider.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-01-07-aig-provider-deepseek/
  md: https://developers.cloudflare.com/changelog/2025-01-07-aig-provider-deepseek/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## AI Gateway adds DeepSeek as a Provider

Jan 02, 2025

[AI Gateway](https://developers.cloudflare.com/ai-gateway/)

[**AI Gateway**](https://developers.cloudflare.com/ai-gateway/) now supports [**DeepSeek**](https://developers.cloudflare.com/ai-gateway/usage/providers/deepseek/), including their cutting-edge DeepSeek-V3 model. With this addition, you have even more flexibility to manage and optimize your AI workloads using AI Gateway. Whether you're leveraging DeepSeek or other providers, like OpenAI, Anthropic, or [Workers AI](https://developers.cloudflare.com/workers-ai/), AI Gateway empowers you to:

* **Monitor**: Gain actionable insights with analytics and logs.
* **Control**: Implement caching, rate limiting, and fallbacks.
* **Optimize**: Improve performance with feedback and evaluations.

![AI Gateway adds DeepSeek as a provider](https://developers.cloudflare.com/_astro/deepseek.hirkr3rv_CnIYs.webp)

To get started, simply update the base URL of your DeepSeek API calls to route through AI Gateway. Here's how you can send a request using cURL:

```bash
curl https://gateway.ai.cloudflare.com/v1/{account_id}/{gateway_id}/deepseek/chat/completions \
 --header 'content-type: application/json' \
 --header 'Authorization: Bearer DEEPSEEK_TOKEN' \
 --data '{
    "model": "deepseek-chat",
    "messages": [
        {
            "role": "user",
            "content": "What is Cloudflare?"
        }
    ]
}'
```

For detailed setup instructions, see our [DeepSeek provider documentation](https://developers.cloudflare.com/ai-gateway/usage/providers/deepseek/).
