---
title: Load shedding · Cloudflare Load Balancing docs
description: Use load shedding to prevent an at-risk endpoint from becoming
  unhealthy and starting the failover process.
lastUpdated: 2025-10-09T15:47:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/additional-options/load-shedding/
  md: https://developers.cloudflare.com/load-balancing/additional-options/load-shedding/index.md
---

Use load shedding to prevent an at-risk endpoint from [becoming unhealthy](https://developers.cloudflare.com/load-balancing/understand-basics/health-details/) and starting the failover process.

Once you configure load shedding on a pool, that pool will begin diverting traffic to other pools according to your load shedding settings and the load balancer's [steering policy](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/steering-policies/).

## Step 1 — Identify at-risk endpoints

Using your internal metrics, identify endpoints at risk of reaching their failure threshold.

* If your endpoint is seeing increased traffic but is not yet at risk of failure, start with [Step 2](#step-2--shed-default-traffic-from-a-pool).
* If your endpoint is about to fail, start with [Step 4](#step-4--shed-additional-traffic-optional).

## Step 2 — Shed default traffic from a pool

Once you have identified an at-risk endpoint, shed a small amount of **Default** traffic from that endpoint's pool. This traffic is not affiliated with existing [Session affinity](https://developers.cloudflare.com/load-balancing/understand-basics/session-affinity/) sessions.

Configure load shedding via the [dashboard](#configure-via-dashboard) or the [API](#configure-via-api).

### Configure via dashboard

To enable load shedding for a specific pool via the dashboard:

1. Go to **Load Balancing**.
2. Select the **Pools** tab.
3. On a pool, select **Edit**.
4. Open the **Configure Load Shedding** dropdown.
5. For **Default traffic**, select a **Policy** and a **Shed %**:

Policy options

When shedding **Default traffic**, you have two **Policy** options:

* **Random**: Randomly sheds the percentage of requests specified in the *Shed %*. Distributes traffic more accurately, but may cause requests from the same IP to hit different endpoints.
* **IP hash**: Sheds the percentage of IP address hash space specified in the *Shed %*. Ensures requests from the same IP will hit the same endpoint, but may shed a significantly higher or lower percentage of requests.

For more guidance on choosing a policy, refer to [Shedding policies](#shedding-policies).

Shed %

When choosing a **Shed %**, start with a small percentage and increase gradually. Particularly if you choose the [IP hash shedding policy](#shedding-policies), you might shed more traffic than expected.

### Configure via API

To enable load shedding for a specific pool via the API, [update the values](https://developers.cloudflare.com/api/resources/load_balancers/subresources/pools/methods/update/) for the pool's `load_shedding` object.

Example request

```bash
curl --request PATCH \
"https://api.cloudflare.com/client/v4/accounts/{account_id}/load_balancers/pools/{pool_id}" \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data-binary '{
  "load_shedding": {
    "default_percent": 20,
    "default_policy": "random",
    "session_percent": 0,
    "session_policy": "hash"
  }
}'
```

For more guidance on choosing a shedding policy, see [Shedding policies](#shedding-policies).

## Step 3 — Monitor traffic

Once you have started shedding default traffic, evaluate the effects by reviewing the [**Overview** metrics](https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/) in Load Balancing analytics. Based on these numbers and your internal metrics, you will know whether you need to divert additional traffic from the pool.

If you see increased traffic to a pool, you may need to shed additional traffic. Pools shed a percentage of total traffic, so any increase in total traffic will also increase the traffic reaching your pool.

## Step 4 — Shed additional traffic (optional)

If you need to shed additional pool traffic:

1. Follow the steps outlined in [Step 2](#step-2--shed-default-traffic-from-a-pool).

   * In the dashboard, increase the **Shed %** for **Default traffic** and/or **Session affinity traffic**.
   * For the API, increase the value for `default_percent` and/or `session_percent`.

Since shedding **Session Affinity traffic** will disrupt [existing sessions](https://developers.cloudflare.com/load-balancing/understand-basics/session-affinity/) and may degrade the customer experience, only enable this option if your pool is in imminent danger of becoming unhealthy or your pool has a high percentage of traffic related to existing sessions. For more guidance, see [Shedding policies](#shedding-policies).

## Step 5 — Disable load shedding

Once an endpoint is no longer at risk, remove load shedding from the pool.

To remove load shedding in the dashboard, perform the same steps as [Configure load shedding via the dashboard](#configure-via-dashboard) but set the **Shed %** to `0` for both **Default traffic** and **Session affinity traffic**.

To remove load shedding via the API, perform the same steps as [Configure load shedding via the API](#configure-via-api) but set the `load_shedding` object to `null`.

## Additional notes

### Shedding policies

For **Default traffic**, you have two choices for shedding policy.

A *Random* policy:

* Randomly sheds the percentage of requests specified in the *Shed %*.
* Distributes traffic more accurately because it sheds at the request level.
* May cause requests from the same IP to hit different endpoints, potentially leading to cache misses, inconsistent latency, or session disruption for [DNS-only load balancers](https://developers.cloudflare.com/load-balancing/understand-basics/proxy-modes/#dns-only-load-balancing).

An *IP hash* policy:

* Sheds the percentage of IP address hash space specified in the *Shed %*.
* Ensures requests from the same IP will hit the same endpoint, which will increase cache hits, provide consistent latency, and preserve sessions.
* Can over- or under-shed requests, since hashing does not guarantee a perfectly even IP distribution and individual IPs may be responsible for different percentages of your requests.

Choose a *Random* policy when you want a more accurate distribution of raw requests and an *IP hash* policy when you want to prevent a single IP from flapping between different endpoints.

For **Session Affinity traffic**, you can only use an *IP hash* policy since these requests relate to existing sessions. Only increase the *Shed %* if you are comfortable disrupting [existing sessions](https://developers.cloudflare.com/load-balancing/understand-basics/session-affinity/).

### Fallback pools

If all pools within a load balancer have *Load shedding* enabled, some traffic will go to the fallback pool. To prevent any traffic from reaching the fallback pool, ensure at least one pool within the load balancer **does not** have load shedding enabled.

### Pools in multiple load balancers

If you enable load shedding on a pool, it will shed the same percentage of traffic across all your load balancers. If you need an endpoint to shed different percentages of traffic for different load balancers, put that endpoint in multiple pools.
