---
title: Overview · Cloudflare Radar docs
description: Cloudflare Radar is a hub that showcases global Internet traffic,
  attacks, and technology trends and insights. It is powered by data from
  Cloudflare’s global network, as well as aggregated and anonymized data from
  Cloudflare’s 1.1.1.1 public DNS resolver.
lastUpdated: 2025-05-02T13:54:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/radar/
  md: https://developers.cloudflare.com/radar/index.md
---

Get access to Cloudflare's data on global Internet traffic.

Available on all plans

[Cloudflare Radar](https://radar.cloudflare.com) is a hub that showcases global Internet traffic, attacks, and technology trends and insights. It is powered by data from [Cloudflare’s global network](https://www.cloudflare.com/network/), as well as aggregated and [anonymized data](https://developers.cloudflare.com/1.1.1.1/privacy/public-dns-resolver/) from Cloudflare’s [1.1.1.1 public DNS resolver](https://developers.cloudflare.com/1.1.1.1/).

Using [Radar's API](https://developers.cloudflare.com/api/resources/radar/) you can access Cloudflare's data on global Internet traffic. Radar's API is free, allowing academics, technology professionals, and other web enthusiasts to investigate Internet usage across the globe.

Data available via Radar API endpoints is made available under the [CC BY-NC 4.0](https://creativecommons.org/licenses/by-nc/4.0/) license.

[Get started](https://developers.cloudflare.com/radar/get-started/)

[Radar website](https://radar.cloudflare.com/)

***

## Features

### Make your first API request

Start learning how to use Radar's API by making your first request.

[Make your first API request](https://developers.cloudflare.com/radar/get-started/first-request/)

### Compare data

What to know before making comparisons between locations, [autonomous systems](https://www.cloudflare.com/en-gb/learning/network-layer/what-is-an-autonomous-system/), and more.

[Compare data](https://developers.cloudflare.com/radar/get-started/making-comparisons/)

### URL Scanner

Understand the security, performance, technology, and network details of a URL with a publicly shareable report.

[Use URL Scanner](https://developers.cloudflare.com/radar/investigate/url-scanner/)

***

## More resources

[Investigate](https://developers.cloudflare.com/radar/investigate/)

Explore the diverse data available in Cloudflare Radar, including NetFlows, HTTP requests, DNS queries, and much more.

[@CloudflareRadar](https://x.com/cloudflareradar)

Follow @CloudflareRadar on X to learn about Internet trends, as seen by the Cloudflare global network.

[@cloudflareradar](https://noc.social/@cloudflareradar)

Follow @cloudflareradar on Mastodon to learn about Internet trends, as seen by the Cloudflare global network.

[@radar.cloudflare.com](https://bsky.app/profile/radar.cloudflare.com)

Follow @radar.cloudflare.com on Bluesky to learn about Internet trends, as seen by the Cloudflare global network.

[Cloudflare blog](https://blog.cloudflare.com/tag/cloudflare-radar/)

Read articles about the latest trends and updates on Cloudflare Radar.

[MCP Server](https://github.com/cloudflare/mcp-server-cloudflare/tree/main/apps/radar#cloudflare-radar-mcp-server-)

Enable any MCP client to access and explore trends and insights on Cloudflare Radar.
