---
title: Hotlink Protection · Cloudflare Web Application Firewall (WAF) docs
description: Hotlink Protection prevents your images from being used by other
  sites, which can reduce the bandwidth consumed by your origin server.
lastUpdated: 2025-10-17T11:29:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/scrape-shield/hotlink-protection/
  md: https://developers.cloudflare.com/waf/tools/scrape-shield/hotlink-protection/index.md
---

Hotlink Protection prevents your images from being used by other sites, which can reduce the bandwidth consumed by your [origin server](https://www.cloudflare.com/learning/cdn/glossary/origin-server/).

The supported file extensions are `gif`, `ico`, `jpg`, `jpeg`, and `png`.

## Background

When Cloudflare receives an image request for your site, we check to ensure the request did not originate from visitors on another site. Visitors to your domain will still be able to download and view images.

Technically, this means that Hotlink Protection denies access to requests when the HTTP referer does not include your website domain name (and is not blank).

Hotlink protection has no impact on crawling, but it will prevent the images from being displayed on sites such as Google images, Pinterest, and Facebook.

## Enable Hotlink Protection

* Dashboard

  To enable **Hotlink Protection** in the dashboard:

  1. In the Cloudflare dashboard, go to the **Scrape Shield** page.

     [Go to **Scrape Shield**](https://dash.cloudflare.com/?to=/:account/:zone/content-protection)

  2. For **Hotlink Protection**, switch the toggle to **On**.

* API

  To enable **Hotlink Protection** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `hotlink_protection` as the setting name in the URI path, and the `value` parameter set to `"on"`.

Note

To use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).

### SaaS providers using Cloudflare

If you are a SaaS provider using [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/), note that, by default, Hotlink Protection will only allow requests with your zone as referer. To avoid blocking requests from your customers (custom hostnames), consider using [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/settings/#hotlink-protection) or [custom rules](https://developers.cloudflare.com/waf/custom-rules/use-cases/exempt-partners-hotlink-protection/).

***

## Allow hotlinking to specific images

You may want certain images to be hotlinked to, whether by external websites (like Google) or certain situations like when using an RSS feed.

### Configuration rules

To disable Hotlink Protection selectively, create a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/) covering the path of an image folder.

### hotlink-ok directory

You can allow certain images to be hotlinked by placing them in a directory named `hotlink-ok`. The `hotlink-ok` directory can be placed anywhere on your website.

To allow another website to use `logo.png` from `example.com`, put `logo.png` in a new folder called `hotlink-ok`.

Some examples of URLs that will not be checked for hotlinking:

* `http://example.com/hotlink-ok/pic.jpg`
* `http://example.com/images/hotlink-ok/pic.jpg`
* `http://example.com/hotlink-ok/images/pic.jpg`
* `http://example.com/images/main-site/hotlink-ok/pic.jpg`
